<?php
require_once '../config/db.php';

try {
    // Rename refund_date to refunded_at in refunds table
    $pdo->exec("ALTER TABLE refunds CHANGE COLUMN refund_date refunded_at DATETIME NOT NULL");
    echo "Renamed refund_date to refunded_at in refunds table.\n";

    // Rename total column to total_price
    $pdo->exec("ALTER TABLE refund_items CHANGE COLUMN `total` `total_price` DECIMAL(10,2) NOT NULL");
    echo "Renamed total column to total_price successfully.\n";

    // Add restock_quantity column if it doesn't exist
    $pdo->exec("ALTER TABLE refund_items ADD COLUMN IF NOT EXISTS `restock_quantity` INT NOT NULL DEFAULT 0");
    echo "Added restock_quantity column successfully.\n";

    echo "Refund items table updated successfully!";
} catch (PDOException $e) {
    echo "Error updating refund items table: " . $e->getMessage();
} 